{--------------------------------------------------------------}
{                         SortTest                             }
{                                                              }
{               Data sort demonstration program                }
{                                                              }
{                             by Jeff Duntemann                }
{                             FreePascal V3.0                  }
{                             Last update 10/30/2016           }
{                                                              }
{     From: FREEPASCAL FROM SQUARE ONE  by Jeff Duntemann      }
{--------------------------------------------------------------}

PROGRAM SortTest;

USES CRT,DOS,   { Standard Borland units }
     BoxStuff;  { Unit for drawing boxes; see Chapter 13 }

CONST
  Highlite   = True;  { These first 4 constants are used by WriteAt }
  NoHighlite = False;
  NoCR       = False;
  Shell      = True;  { Which sort procedure will we be using? }
  Quick      = False;

TYPE
  String30  = STRING[30];

  KeyRec    = RECORD
                Ref     : Integer;
                KeyData : String30
              END;

  KeyArray  = ARRAY[0..500] OF KeyRec;
  KeyFile   = FILE OF KeyRec;

VAR
  IVal      : Integer;   { Holds integer value for user's response }
  WorkArray : KeyArray;
  Randoms   : KeyFile;   { Files should generally be declared global }


{$I PULL.SRC }      { Described in Section 16.12 }
{$I CLREGION.SRC}   { Described in Section 18.1 }
{$I WRITEAT.SRC}    { Described in Section 18.3 }
{$I SHELSORT.SRC}   { Described in Section 14.2 }
{$I QUIKSORT.SRC}   { Described in Section 14.4 }


PROCEDURE GenerateRandomKeyFile(KeyQuantity : Integer);

VAR WorkKey : KeyRec;
    I,J     : Word;

BEGIN
  Assign(Randoms,'randoms.key');
  Rewrite(Randoms);
  FOR I := 1 TO KeyQuantity DO
    BEGIN
      FillChar(WorkKey,SizeOf(WorkKey),0);
      FOR J := 1 TO SizeOf(WorkKey.KeyData)-1 DO
        WorkKey.KeyData[J] := Chr(Pull(65,90));
      WorkKey.KeyData[0] := Chr(30);
      Write(Randoms,WorkKey);
    END;
  Close(Randoms)
END;


PROCEDURE DisplayKeys;

VAR WorkKey : KeyRec;

BEGIN
  Assign(Randoms,'randoms.key');
  Reset(Randoms);
  Window(25,13,70,22);
  GotoXY(1,1);
  WHILE NOT EOF(Randoms) DO
    BEGIN
      Read(Randoms,WorkKey);
      IF NOT EOF(Randoms) THEN Writeln(WorkKey.KeyData)
    END;
  Close(Randoms);
  Writeln;
  Writeln('        >>Press (CR)<<');
  Readln;
  ClrScr;
  Window(1,1,80,25)
END;


PROCEDURE DoSort(Shell : Boolean);

VAR I,Counter : Word;

BEGIN
  Assign(Randoms,'randoms.key');
  Reset(Randoms);
  Counter := 1;
  WriteAt(20,15,NoHighlite,NoCR,'Loading...');
  WHILE NOT EOF(Randoms) DO
    BEGIN
      Read(Randoms,WorkArray[Counter]);
      Counter := Succ(Counter)
    END;
  Close(Randoms);
  Write('...sorting...');
  IF Shell THEN ShellSort(WorkArray,Counter-1)
    ELSE QuickSort(WorkArray,Counter-1);
  Write('...writing...');
  Rewrite(Randoms);
  FOR I := 1 TO Counter-1 DO Write(Randoms,WorkArray[I]);
  Close(Randoms);
  Writeln('...done!');
  WriteAt(-1,21,NoHighlite,NoCR,'>>Press (CR)<<');
  Readln;
  ClearRegion(2,15,77,22)
END;

BEGIN
  ClrScr;
  MakeBox(1,1,80,24,PCLineChars);
  WriteAt(18,3,HighLite,NoCR,'FreePascal From Square One Sort Demo');
  REPEAT
    WriteAt(25,5,NoHighlite,NoCR,'[1] Generate file of random keys');
    WriteAt(25,6,NoHighlite,NoCR,'[2] Display file of random keys');
    WriteAt(25,7,NoHighlite,NoCR,'[3] Sort file via Shell sort');
    WriteAt(25,8,NoHighlite,NoCR,'[4] Sort file via Quicksort');
    WriteAt(18,10,NoHighlite,NoCR,'Enter 1-4, or 0 to quit, and press Enter: ');
    IVal := 0;
    Readln(IVal);
    CASE IVal OF
      0 :;                            { Null statement here; note semicolon }
      1 : GenerateRandomKeyFile(500); { 500 is as high as you can go...}
      2 : DisplayKeys;
      3 : DoSort(Shell);
      4 : DoSort(Quick);
      ELSE IVal := 0;
    END; {CASE}
  UNTIL (IVal = 0);
END.

