{--------------------------------------------------------------}
{                           Rollem                             }
{                                                              }
{   A dice game to demonstrate random numbers and box draws    }
{                                                              }
{                             by Jeff Duntemann                }
{                             FreePascal 3.0.4                 }
{                             Last update 2/24/2018            }
{                                                              }
{   From: FREEPASCAL FROM SQUARE ONE  by Jeff Duntemann        }
{--------------------------------------------------------------}

PROGRAM Rollem;

USES Crt,BoxStuff;

CONST
  DiceFaces : ARRAY[0..5,0..2] OF STRING[5] =
                   (('     ','  o  ','     '),  { 1 }
                    ('o    ','     ','    o'),  { 2 }
                    ('    o','  o  ','o    '),  { 3 }
                    ('o   o','     ','o   o'),  { 4 }
                    ('o   o','  o  ','o   o'),  { 5 }
                    ('o o o','     ','o o o')); { 6 }


TYPE
  String80  = String[80];


VAR
  I            : Integer;
  Quit         : Boolean;
  Dice         : Integer;
  DiceX        : Integer;
  Ch           : Char;
  Banner       : String80;



PROCEDURE Roll(X,Y          : Integer;
               NumberOfDice : Integer);

VAR I,J,Throw,XOffset : Integer;

BEGIN
  IF (NumberOfDice * 9)+X >= 80 THEN      { Too many dice horizontally     }
    NumberOfDice := (80-X) DIV 9;         { will scramble the CRT display! }
  FOR I := 1 TO NumberOfDice DO
    BEGIN
      XOffset := (I-1)*9;                 { Nine space offset for each die }
      MakeBox(X+XOffset,Y,7,5,PCLineChars); { Draw a die }
      Throw := Random(6);                 { "Toss" it  }
      FOR J := 0 TO 2 DO                  { and fill it with dots }
        BEGIN
          GotoXY(X+1+XOffset,Y+1+J);
          Write(DiceFaces[Throw,J])
        END
    END
 END;

BEGIN
  Randomize;                   { Seed the pseudorandom number generator }
  ClrScr;                      { Clear the entire screen }
  Quit := False;               { Initialize the quit flag }
  Banner := 'GONNA Roll THE BONES!';
  MakeBox(-1,1,Length(Banner)+4,3,PCLineChars);        { Draw Banner box }
  GotoXY((80-Length(Banner)) DIV 2,2); Write(Banner);  { Put Banner in it }
  REPEAT
    REPEAT
      FOR I := 6 TO 18 DO      { Clear the game portion of screen }
        BEGIN
          GotoXY(1,I);
          ClrEol
        END;
      GotoXY(1,6);
      Write('>>How many dice will we Roll this game? (1-5, or 0 to exit): ');
      Readln(Dice);
      IF Dice = 0 THEN Quit := True ELSE  { Zero dice sets Quit flag }
        IF (Dice < 1) OR (Dice > 5) THEN  { Show error for dice out of range }
          BEGIN
            GotoXY(0,23);
            Write('>>The legal range is 1-5 Dice!')
          END
    UNTIL (Dice >= 0) AND (Dice <= 5);
    GotoXY(0,23); ClrEol;       { Get rid of any leftover error messages }
    IF NOT Quit THEN            { Play the game! }
      BEGIN
        DiceX := (80-(9*Dice)) DIV 2;   { Calculate centered X for dice }
        REPEAT
          GotoXY(1,16); ClrEol;
          Roll(DiceX,9,Dice);                      { Roll & draw dice }
          GotoXY(1,16); Write('>>Roll again? (Y/N): ');
          Readln(Ch);
        UNTIL NOT (Ch IN ['Y','y']);
        GotoXY(1,18); Write('>>Play another game? (Y/N): ');
        Readln(Ch);
        IF NOT (Ch IN ['Y','y']) THEN Quit := True
      END
  UNTIL Quit      { Quit flag set ends the game }
END.
