{--------------------------------------------------------------}
{                          BoxStuff                            }
{                                                              }
{ Unit to demonstrate separate compilation -- draws text boxes }
{                                                              }
{                             by Jeff Duntemann                }
{                             FreePascal 3.0.4                 }
{                             Last update 11/15/2019           }
{                                                              }
{     From: FREEPASCAL FROM SQUARE ONE  by Jeff Duntemann      }
{--------------------------------------------------------------}

UNIT BOXSTUFF;

INTERFACE

USES Crt;     { For GotoXY }

TYPE
  LineRec = RECORD
              ULCorner,
              URCorner,
              LLCorner,
              LRCorner,
              HBar,
              VBar,
              LineCross,
              TDown,
              TUp,
              TRight,
              TLeft : String[4]
            END;


{ PCLineChars: }
{ Contains box-drawing strings for MakeBox.}
{ Any program or unit that USES BoxStuff   }
{ can access the PCLineChars constant just }
{ as though it had been defined within the }
{ USEing program or unit.                  }

CONST
  PCLineChars : LineRec =
    (ULCorner : #201;
     URCorner : #187;
     LLCorner : #200;
     LRCorner : #188;
     HBar     : #205;
     VBar     : #186;
     LineCross: #206;
     TDown    : #203;
     TUp      : #202;
     TRight   : #185;
     TLeft    : #204);


{<<<< MakeBox >>>>}
{ This is all that the "outside world" really needs to see of the }
{ MakeBox procedure.  *How* it happens is irrelevant to using it. }

PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  LineChars        : LineRec);

IMPLEMENTATION

{ <<<<MakeBox>>>> }
{ Note here that the parameter line does not have to be repeated. }
{ (We gave the full parameter list definition in the INTERFACE.)  }
{ But since it does no harm, you might as well re-state the       }
{ parameter list.  That makes it easier to read the full source   }
{ for MakeBox. }

PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  LineChars        : LineRec);

VAR
  I : Integer;

BEGIN
  IF X < 0 THEN X := (80-Width) DIV 2;    { Negative X centers box }
  WITH LineChars DO
    BEGIN                                 { Draw top line }
      GotoXY(X,Y); Write(ULCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(URCorner);
                                          { Draw bottom line }
      GotoXY(X,(Y+Height)-1); Write(LLCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(LRCorner);
                                          { Draw sides }
      FOR I := 1 TO Height-2 DO
        BEGIN
          GotoXY(X,Y+I); Write(VBar);
          GotoXY((X+Width)-1,Y+I); Write(VBar)
        END
    END
END;


END.

