{--------------------------------------------------------------}
{                          BoxTest                             }
{                                                              }
{ Character box-draw demo program; demos concept of procedures }
{                                                              }
{                             by Jeff Duntemann                }
{                             FreePascal 3.0                   }
{                             Last update 10/29/2016           }
{                                                              }
{    From: FREEPASCAL FROM SQUARE ONE  by Jeff Duntemann       }
{--------------------------------------------------------------}

PROGRAM BoxTest;

USES Crt;

TYPE
  LineRec = RECORD
              ULCorner,
              URCorner,
              LLCorner,
              LRCorner,
              HBar,
              VBar,
              LineCross,
              TDown,
              TUp,
              TRight,
              TLeft : String[4]
            END;


CONST
  PCLineChars : LineRec =
    (ULCorner : #201;
     URCorner : #187;
     LLCorner : #200;
     LRCorner : #188;
     HBar     : #205;
     VBar     : #186;
     LineCross: #206;
     TDown    : #203;
     TUp      : #202;
     TRight   : #185;
     TLeft    : #204);


VAR
  X,Y          : Integer;
  Width,Height : Integer;


PROCEDURE MakeBox(X,Y,Width,Height : Integer;
                  LineChars        : LineRec);

VAR
  I : Integer;

BEGIN
  IF X < 0 THEN X := (80-Width) DIV 2;    { Negative X centers box }
  WITH LineChars DO
    BEGIN                                 { Draw top line }
      GotoXY(X,Y); Write(ULCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(URCorner);
                                          { Draw bottom line }
      GotoXY(X,(Y+Height)-1); Write(LLCorner);
      FOR I := 3 TO Width DO Write(HBar);
      Write(LRCorner);
                                          { Draw sides }
      FOR I := 1 TO Height-2 DO
        BEGIN
          GotoXY(X,Y+I); Write(VBar);
          GotoXY((X+Width)-1,Y+I); Write(VBar)
        END
    END
END;



BEGIN
  Randomize;                 { Seed the pseudorandom number generator }
  ClrScr;                    { Clear the entire text window }
  WHILE NOT KeyPressed DO    { Draw boxes until any key is pressed }
    BEGIN
      X := Random(72);       { Get a Random X/Y for UL Corner of box }
      Y := Random(21);
      REPEAT Width := Random(80-72) UNTIL Width > 1;  { Get Random Height & }
      REPEAT Height := Random(25-Y) UNTIL Height > 1; { Width to fit on CRT }
      MakeBox(X,Y,Width,Height,PCLineChars);          { and draw it! }
      Delay(25);
    END
END.

