{--------------------------------------------------------------}
{                          Aliens                              }
{                                                              }
{                             by Jeff Duntemann                }
{                             FreePascal V2.2.0                }
{                             Last update 2/8/2008             }
{                                                              }
{    From: FREEPASCAL FROM SQUARE ONE  by Jeff Duntemann       }
{--------------------------------------------------------------}

PROGRAM Aliens;

USES Crt;               { For ClrScr, Random, and Randomize }

CONST
  MaxLength  = 9;       { The longest name we’ll try to generate  }
  MinLength  = 2;       { The shortest name we’ll try to generate }
  LastLetter = 122;     { Lower-case ‘z’ in the ASCII symbol set  }

TYPE
  NameString = STRING[MaxLength];  { Waste no space in our strings! }
  CharSet    = SET OF Char;        { To weed out odd symbols        }

VAR
  Printables   : SET OF Char; { Holds the set of printable letters  }
  I,J          : Integer;     { General-purpose counter variables   }
  NameLength   : Integer;     { Holds the length of each name }
  NameChar     : Char;        { Holds a randomly-selected character }
  NamesWanted  : Integer;     { Holds the number of names we want   }
  CurrentName  : NameString;  { Holds the name we’re working on }

BEGIN
  Randomize;                  { Seed the random number generator }
  Printables := ['A'..'Z','a'..'z'];  { Only printable letters! }
  ClrScr;

  Write('How many alien names do you want? (1-10): ');
  Readln(NamesWanted);        { Answer the question }

  FOR I := 1 TO NamesWanted DO
    BEGIN
      CurrentName := '';      { Start with an empty name }

      REPEAT
       NameLength := Random(MaxLength);  { Pick length for this name }
      UNTIL NameLength > MinLength;

      FOR J := 1 TO NameLength DO     { Pick a letter: }
        BEGIN
          REPEAT   { We keep picking letters until one is printable: }
            NameChar := Chr(Random(LastLetter));
          UNTIL NameChar IN Printables;
          CurrentName := CurrentName + NameChar;  { Add it to the name }
        END;
      Writeln(CurrentName);   { Finally, display the completed name }
    END;
  Readln; { Pause until Enter hit; so you can admire the alien names }
END.
